/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.Color;
import java.io.IOException;

public class ColorTypeAdapter
extends TypeAdapter<Color> {
    @Override
    public void write(JsonWriter out, Color value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        int rgba = value.getRGB();
        out.value(String.format("#%08X", rgba));
    }

    @Override
    public Color read(JsonReader in2) throws IOException {
        switch (in2.peek()) {
            case NULL: {
                in2.nextNull();
                return null;
            }
            case STRING: {
                String value = in2.nextString();
                if (value.charAt(0) == '#') {
                    value = value.substring(1);
                }
                int intValue = Integer.parseUnsignedInt(value, 16);
                return new Color(intValue, true);
            }
            case BEGIN_OBJECT: {
                in2.beginObject();
                double value = 0.0;
                block11: while (in2.peek() != JsonToken.END_OBJECT) {
                    switch (in2.nextName()) {
                        case "value": {
                            value = in2.nextDouble();
                            continue block11;
                        }
                    }
                    in2.skipValue();
                }
                in2.endObject();
                return new Color((int)value, true);
            }
        }
        return null;
    }
}

